/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.autoplot.AutoplotUtil;
import org.autoplot.EventsListToolUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.pngwalk.CreatePngWalk;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;

public class CreatePngWalkDialog
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.pngwalk");
    private JCheckBox autorangeCB;
    private JCheckBox autorangeFlagsCB;
    private JCheckBox batchUriNameCB;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JCheckBox createThumbsCb;
    private JRadioButton eventsFileRadioButton;
    private DataSetSelector eventsFileSelector;
    private JTextField flnRootTf;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField outputFolderTf;
    private JCheckBox overwriteCB;
    private JRadioButton pdfFormatCB;
    private JButton pickFolderButton;
    private JRadioButton pngFormatCB;
    private JCheckBox removeNoDataImagesCB;
    private JComboBox rescaleComboBox;
    private JCheckBox runOnCopyCB;
    private JComboBox timeFormatCB;
    private JRadioButton timeRangeRadioButton;
    private JTextField timeRangeTf;
    private JButton timeRangeToolButton;
    private JCheckBox updateCB;
    private JTextField versionTextField;
    private BindingGroup bindingGroup;

    public CreatePngWalkDialog() {
        this.initComponents();
        EventsListToolUtil.deflts(this.eventsFileSelector);
        String home = System.getProperty("user.home") + System.getProperty("file.separator");
        home = home.replaceAll("\\\\", "/");
        this.outputFolderTf.setText(home + "pngwalk/");
        this.setDefaults();
        this.checkExists();
    }

    private void setDefaults() {
        Preferences prefs = AutoplotSettings.settings().getPreferences(CreatePngWalkDialog.class);
        String file = prefs.get("filenameRoot", this.flnRootTf.getText());
        this.flnRootTf.setText(file);
        String home = prefs.get("outputFolder", this.outputFolderTf.getText());
        this.outputFolderTf.setText(home);
        String timeFormat = prefs.get("timeFormat", (String)this.timeFormatCB.getSelectedItem());
        this.timeFormatCB.setSelectedItem(timeFormat);
        String timeRange = prefs.get("timeRange", this.timeRangeTf.getText());
        this.timeRangeTf.setText(timeRange);
        boolean thumbs = prefs.getBoolean("createThumbs", this.createThumbsCb.isSelected());
        this.createThumbsCb.setSelected(thumbs);
        boolean useTimeRange = prefs.getBoolean("useTimeRange", this.timeRangeRadioButton.isSelected());
        this.timeRangeRadioButton.setSelected(useTimeRange);
        boolean useEventsFile = prefs.getBoolean("useEventsFile", this.eventsFileRadioButton.isSelected());
        this.eventsFileRadioButton.setSelected(useEventsFile);
        this.batchUriNameCB.setSelected(prefs.get("batchUriName", "").equals("$o"));
        this.timeFormatCB.setEnabled(!this.batchUriNameCB.isSelected());
        String eventsFile = prefs.get("eventsFile", this.eventsFileSelector.getValue());
        this.eventsFileSelector.setValue(eventsFile);
        this.autorangeCB.setSelected(prefs.getBoolean("autorange", this.autorangeCB.isSelected()));
        this.autorangeFlagsCB.setSelected(prefs.getBoolean("autorangeFlags", this.autorangeFlagsCB.isSelected()));
        this.rescaleComboBox.setSelectedItem(prefs.get("rescalex", (String)this.rescaleComboBox.getSelectedItem()));
        this.updateCB.setSelected(prefs.getBoolean("update", this.updateCB.isSelected()));
        this.runOnCopyCB.setSelected(prefs.getBoolean("runOnCopy", this.runOnCopyCB.isSelected()));
        this.versionTextField.setText(prefs.get("version", this.versionTextField.getText()));
        this.removeNoDataImagesCB.setSelected(prefs.getBoolean("removeNoData", this.removeNoDataImagesCB.isSelected()));
        this.pngFormatCB.setSelected(prefs.get("outputFormat", this.pngFormatCB.isSelected() ? "png" : "pdf").equals("png"));
        this.pdfFormatCB.setSelected(prefs.get("outputFormat", this.pngFormatCB.isSelected() ? "png" : "pdf").equals("pdf"));
    }

    public void writeDefaults() {
        Preferences prefs = AutoplotSettings.settings().getPreferences(CreatePngWalkDialog.class);
        prefs.put("filenameRoot", this.flnRootTf.getText().trim());
        File ff = this.getOutputFolder(this.getOutputFolderTf().getText().trim());
        prefs.put("outputFolder", DataSetURI.fromFile((File)ff).substring(7));
        prefs.put("timeFormat", ((String)this.timeFormatCB.getSelectedItem()).trim());
        prefs.put("timeRange", this.timeRangeTf.getText().trim());
        prefs.putBoolean("createThumbs", this.createThumbsCb.isSelected());
        prefs.putBoolean("autorange", this.autorangeCB.isSelected());
        prefs.putBoolean("autorangeFlags", this.autorangeFlagsCB.isSelected());
        prefs.put("rescalex", ((String)this.rescaleComboBox.getSelectedItem()).trim());
        prefs.putBoolean("update", this.updateCB.isSelected());
        prefs.putBoolean("removeNoData", this.removeNoDataImagesCB.isSelected());
        prefs.putBoolean("runOnCopy", this.runOnCopyCB.isSelected());
        prefs.put("version", this.versionTextField.getText().trim());
        prefs.putBoolean("useTimeRange", this.timeRangeRadioButton.isSelected());
        prefs.putBoolean("useEventsFile", this.eventsFileRadioButton.isSelected());
        prefs.put("eventsFile", this.eventsFileSelector.getValue());
        prefs.put("batchUriName", this.batchUriNameCB.isSelected() ? "$o" : "");
        prefs.put("outputFormat", this.pngFormatCB.isSelected() ? "png" : "pdf");
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private File getOutputFolder(String sff) {
        if (sff.startsWith("file://")) {
            sff = sff.substring(7);
        }
        if (sff.startsWith("file:")) {
            sff = sff.substring(5);
        }
        File ff = new File(sff);
        return ff;
    }

    public CreatePngWalk.Params getParams() {
        CreatePngWalk.Params params = new CreatePngWalk.Params();
        File ff = this.getOutputFolder(this.getOutputFolderTf().getText().trim());
        params.outputFolder = DataSetURI.fromFile((File)ff).substring(7);
        if (!params.outputFolder.endsWith("/")) {
            params.outputFolder = params.outputFolder + "/";
        }
        params.timeRangeStr = this.getTimeRangeTf().getText().trim();
        params.product = this.getFlnRootTf().getText().trim();
        params.timeFormat = ((String)this.getTimeFormatCB().getSelectedItem()).trim();
        params.createThumbs = this.getCreateThumbsCb().isSelected();
        params.autorange = this.autorangeCB.isSelected();
        params.autorangeFlags = this.autorangeFlagsCB.isSelected();
        params.rescalex = ((String)this.rescaleComboBox.getSelectedItem()).trim();
        params.update = this.updateCB.isSelected();
        params.runOnCopy = this.runOnCopyCB.isSelected();
        params.removeNoData = this.removeNoDataImagesCB.isSelected();
        params.version = this.versionTextField.getText().trim();
        String s = this.eventsFileSelector.getValue();
        params.batchUri = s.startsWith("(") && s.endsWith(")") ? "" : this.eventsFileSelector.getValue();
        params.useBatchUri = this.eventsFileRadioButton.isSelected();
        if (this.batchUriNameCB.isSelected()) {
            params.batchUriName = "$o";
        } else {
            params.batchUriName = "";
            if (params.timeFormat.length() < 2) {
                throw new IllegalArgumentException("Time Format must be at least two characters in length");
            }
        }
        params.outputFormat = this.pngFormatCB.isSelected() ? "png" : "pdf";
        return params;
    }

    private void checkExists() {
        String sf = this.outputFolderTf.getText();
        File f = new File(sf);
        this.overwriteCB.setEnabled(f.exists());
        if (!f.exists()) {
            this.overwriteCB.setSelected(false);
        }
    }

    public JTextField getFlnRootTf() {
        return this.flnRootTf;
    }

    public JTextField getOutputFolderTf() {
        return this.outputFolderTf;
    }

    public JTextField getTimeRangeTf() {
        return this.timeRangeTf;
    }

    public JComboBox getTimeFormatCB() {
        return this.timeFormatCB;
    }

    public JCheckBox getCreateThumbsCb() {
        return this.createThumbsCb;
    }

    public JCheckBox getOverwriteCb() {
        return this.overwriteCB;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.flnRootTf = new JTextField();
        this.jLabel2 = new JLabel();
        this.outputFolderTf = new JTextField();
        this.pickFolderButton = new JButton();
        this.jLabel3 = new JLabel();
        this.timeRangeTf = new JTextField();
        this.createThumbsCb = new JCheckBox();
        this.overwriteCB = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.versionTextField = new JTextField();
        this.updateCB = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.rescaleComboBox = new JComboBox();
        this.autorangeCB = new JCheckBox();
        this.timeFormatCB = new JComboBox();
        this.timeRangeToolButton = new JButton();
        this.timeRangeRadioButton = new JRadioButton();
        this.eventsFileRadioButton = new JRadioButton();
        this.eventsFileSelector = new DataSetSelector();
        this.pngFormatCB = new JRadioButton();
        this.pdfFormatCB = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.batchUriNameCB = new JCheckBox();
        this.runOnCopyCB = new JCheckBox();
        this.autorangeFlagsCB = new JCheckBox();
        this.removeNoDataImagesCB = new JCheckBox();
        this.jLabel1.setText("Filename Root:");
        this.jLabel1.setToolTipText("Stem to identify result within folder.");
        this.flnRootTf.setText("product");
        this.flnRootTf.setToolTipText("Stem used to ensure unique filenames");
        this.jLabel2.setText("Output Folder:");
        this.outputFolderTf.setText("/folder/");
        this.outputFolderTf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CreatePngWalkDialog.this.outputFolderTfKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                CreatePngWalkDialog.this.outputFolderTfKeyTyped(evt);
            }
        });
        this.pickFolderButton.setText("Pick");
        this.pickFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePngWalkDialog.this.pickFolderButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Time Format:");
        this.jLabel3.setToolTipText("Time format for each png, used to infer cadence of sequence");
        this.timeRangeTf.setText("2010");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.timeRangeRadioButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.timeRangeTf, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.createThumbsCb.setSelected(true);
        this.createThumbsCb.setText("Create Thumbs");
        this.createThumbsCb.setToolTipText("create thumbs subfolders for performance");
        this.overwriteCB.setText("Overwrite");
        this.overwriteCB.setToolTipText("overwrite existing pngwalk");
        this.jLabel5.setText("Version (Optional):");
        this.jLabel5.setToolTipText("Add this version id to files");
        this.versionTextField.setText(" ");
        this.updateCB.setText("Update Sequence");
        this.updateCB.setToolTipText("Only update the sequence, skipping images already computed");
        this.jLabel6.setText("Rescale (Optional):");
        this.jLabel6.setToolTipText("Rescale before making image, possibly showing surrounding context.");
        this.rescaleComboBox.setEditable(true);
        this.rescaleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0%,100%", "0%-1hr,100%+1hr", "-300%,400%"}));
        this.autorangeCB.setText("Autorange Each");
        this.autorangeCB.setToolTipText("Autorange in Y and Z each image of the sequence");
        this.timeFormatCB.setEditable(true);
        this.timeFormatCB.setModel(new DefaultComboBoxModel<String>(new String[]{"$Y$m$d", "$Y", "$Y$(m,span=3)", "$Y$m", "$Y_$j", "$Y$m$d_$H", "$Y$m$d_$H$M", "$Y$m$d_$H$M$S", "$Y$m$d_$H$M$S.$(subsec,places=3)", "$(o,id=rbspa-pp)", "$(o,id=http://das2.org/Orbits/marsx.dat)", " ", " "}));
        this.timeRangeToolButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/calendar.png")));
        this.timeRangeToolButton.setToolTipText("Use time range tool");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.timeRangeRadioButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.timeRangeToolButton, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.timeRangeToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePngWalkDialog.this.timeRangeToolButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.timeRangeRadioButton);
        this.timeRangeRadioButton.setSelected(true);
        this.timeRangeRadioButton.setText("Generate intervals to cover time range:");
        this.timeRangeRadioButton.setToolTipText("Generate intervals based on the output filename.  For example 2010 with $Y$m$d is covered by 2010-01-01, 2010-01-02, ..., 2010-12-31");
        this.buttonGroup1.add(this.eventsFileRadioButton);
        this.eventsFileRadioButton.setText("Use events file that contains list of times:");
        this.eventsFileRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CreatePngWalkDialog.this.eventsFileRadioButtonItemStateChanged(evt);
            }
        });
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.eventsFileRadioButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.eventsFileSelector, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.buttonGroup2.add(this.pngFormatCB);
        this.pngFormatCB.setText("PNG");
        this.pngFormatCB.setToolTipText("Write PNG files");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.createThumbsCb, (Property)ELProperty.create((String)"${enabled}"), (Object)this.pngFormatCB, (Property)BeanProperty.create((String)"selected"));
        this.bindingGroup.addBinding((Binding)binding);
        this.pngFormatCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePngWalkDialog.this.pngFormatCBActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.pdfFormatCB);
        this.pdfFormatCB.setText("PDF");
        this.pdfFormatCB.setToolTipText("Write PDF files");
        this.jLabel4.setText("Output Format:");
        this.batchUriNameCB.setText("Events file specifies product names");
        this.batchUriNameCB.setToolTipText("<html>The events file contains the file name, so for example instead of product_$Y$m$d,\n<br>just use the last column when generating the filename.\n<br><tt>2000-01-09T06:50:41.155Z\t2000-01-09T13:46:34.224Z\ta/o1\t</tt>\n");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.eventsFileRadioButton, (Property)ELProperty.create((String)"${selected}"), (Object)this.batchUriNameCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.batchUriNameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreatePngWalkDialog.this.batchUriNameCBActionPerformed(evt);
            }
        });
        this.runOnCopyCB.setSelected(true);
        this.runOnCopyCB.setText("Run in background");
        this.runOnCopyCB.setToolTipText("Run the PNG Walk on a copy in the background.  Note only properties conveyed by a .vap file will appear on the produced images.");
        this.autorangeFlagsCB.setText("Check Autorange flag");
        this.autorangeFlagsCB.setToolTipText("Check each axis' autorange property, true indicates the axis should be reset.");
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.autorangeCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.autorangeFlagsCB, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.removeNoDataImagesCB.setText("Remove No Data Images");
        this.removeNoDataImagesCB.setToolTipText("Check that the image produced will actually contain displayed data, and skip those that don't.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.overwriteCB).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.outputFolderTf).addPreferredGap(0).add((Component)this.pickFolderButton)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).add(0, 0, Short.MAX_VALUE))).add(45, 45, 45)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel3).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.timeFormatCB, -2, -1, -2).add(1, (Component)this.flnRootTf)))).add(25, 25, 25)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.createThumbsCb).add(35, 35, 35).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.pngFormatCB).addPreferredGap(0).add((Component)this.pdfFormatCB)).add((Component)this.eventsFileRadioButton).add((Component)this.timeRangeRadioButton).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.eventsFileSelector, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.batchUriNameCB).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.timeRangeTf, -2, 306, -2).addPreferredGap(0).add((Component)this.timeRangeToolButton))).add(0, 0, Short.MAX_VALUE))))).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.autorangeCB, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.updateCB).add((Component)this.jLabel5).add((Component)this.jLabel6).add((Component)this.runOnCopyCB).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rescaleComboBox, -2, 174, -2).add((Component)this.versionTextField, -2, 74, -2).add((Component)this.autorangeFlagsCB))).add((Component)this.removeNoDataImagesCB)).add(0, 0, Short.MAX_VALUE)))))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.outputFolderTf, -2, -1, -2).add((Component)this.pickFolderButton)).addPreferredGap(0).add((Component)this.overwriteCB).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.flnRootTf, -2, -1, -2).add((Component)this.versionTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.timeFormatCB, -2, -1, -2).add((Component)this.rescaleComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.autorangeCB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeRangeRadioButton).add((Component)this.autorangeFlagsCB)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.timeRangeToolButton).add((Component)this.timeRangeTf, -2, -1, -2)).add(7, 7, 7).add((Component)this.eventsFileRadioButton).add(1, 1, 1).add((Component)this.eventsFileSelector, -2, -1, -2).add(3, 3, 3).add((Component)this.batchUriNameCB).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.pngFormatCB).add((Component)this.pdfFormatCB).add((Component)this.jLabel4)).add((Component)this.createThumbsCb))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.updateCB).addPreferredGap(0).add((Component)this.runOnCopyCB).addPreferredGap(0).add((Component)this.removeNoDataImagesCB))).addContainerGap(53, Short.MAX_VALUE)));
        this.bindingGroup.bind();
    }

    private void pickFolderButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.getOutputFolderTf().getText());
        chooser.setFileSelectionMode(1);
        int r = chooser.showSaveDialog(this);
        if (r == 0) {
            this.outputFolderTf.setText(chooser.getSelectedFile().toString());
        }
    }

    private void outputFolderTfKeyTyped(KeyEvent evt) {
        this.checkExists();
    }

    private void outputFolderTfKeyReleased(KeyEvent evt) {
        this.checkExists();
    }

    private void timeRangeToolButtonActionPerformed(ActionEvent evt) {
        TimeRangeTool t = new TimeRangeTool();
        t.setSelectedRange(this.timeRangeTf.getText());
        if (0 == AutoplotUtil.showConfirmDialog(this, t, "Select time range", 2)) {
            String str = t.getSelectedRange();
            this.timeRangeTf.setText(str);
        }
    }

    private void pngFormatCBActionPerformed(ActionEvent evt) {
    }

    private void batchUriNameCBActionPerformed(ActionEvent evt) {
        this.timeFormatCB.setEnabled(!this.batchUriNameCB.isSelected());
    }

    private void eventsFileRadioButtonItemStateChanged(ItemEvent evt) {
        if (!this.eventsFileRadioButton.isSelected()) {
            this.batchUriNameCB.setSelected(false);
            this.timeFormatCB.setEnabled(true);
        }
    }
}

